package gov.va.med.domain.service.messaging.encode.hl7;

import gov.va.med.domain.service.messaging.MessagingConstants;
import gov.va.med.domain.service.messaging.encode.hl7.util.HL7HeaderParameters;
import gov.va.med.domain.service.messaging.encode.hl7.util.HL7v24Helper;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.v24.datatype.XAD;
import ca.uhn.hl7v2.model.v24.datatype.XPN;
import ca.uhn.hl7v2.model.v24.segment.EVN;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.PID;

/**
 * MPILinkUnlinkEncoder
 *
 * @author Slava Uchitel
 * @version $Id: MPILinkUnlinkEncoder.java,v 1.7 2005/07/12 12:13:41 slava.uchitel Exp $
 * @since MHV 2.1 <br>Apr 5, 2005
 */
public abstract class MPILinkUnlinkEncoder extends HL7MessageEncoder {
	private static final String SENDING_APPLICATION = "MPIF TRIGGER";
	private static final String RECEIVING_APPLICATION = "MPIF TRIGGER";
	//Do not change next two lines, this is MPI specific.
	private static final String FIELD_SEPARATOR = "^";
	private static final String DELIMITERS = "~|\\&";

	// override to specify event
	protected String getEvent() {
		return "ADT";
	}

	// override to specify trigger
	protected abstract String getTrigger();

	//override to specify structure
	protected abstract String getStructure();

	protected void fillMSHSegment(MSH msh, HL7HeaderParameters params)
	    throws DataTypeException {
		params.setFieldSeparator(FIELD_SEPARATOR);
		params.setDelimiters(DELIMITERS);
		params.setSrcApplication(SENDING_APPLICATION);
		params.setDstApplication(RECEIVING_APPLICATION);
		params.setEvent(getEvent());
		params.setTrigger(getTrigger());
		HL7v24Helper.fillMSHSegment(msh, params);
	}

	protected void fillEVNSegment(EVN evn, String srcStationNumber)
	    throws DataTypeException {
		//Event Occured
		evn.getEventFacility().getNamespaceID().setValue(srcStationNumber);
	}

	protected void fillPIDSegment(PID pid, 
	        int pidSequence, 
	        String icn, 
	        String dfn,
	        String srcStationNumber, 
	        String firstName, 
	        String lastName)
	    throws DataTypeException, HL7Exception {
	    //FUTURE - add dob and ssn to PIDs
		HL7v24Helper.addIdToPidPID(pid,
		                           icn,
		                           HL7v24Helper.ID_ICN, srcStationNumber, "VA FACILITY ID");
		
		HL7v24Helper.addIdToPidPID(pid,
                dfn,
                HL7v24Helper.ID_DFN, srcStationNumber, "VA FACILITY ID");

		pid.getSetIDPID().setValue(String.valueOf(pidSequence));
		pid.getPatientID().getID().setValue(icn);
		XAD patientAddress = pid.getPatientAddress(0);
		patientAddress.getAddressType().setValue(MessagingConstants.NULL_STRING);
		pid.getCountyCode().setValue(MessagingConstants.NULL_STRING);
		if (firstName != null && lastName != null)
		{    
		    XPN name = pid.getPatientName(0);
		    name.getFamilyName().getSurname().setValue(lastName);
		    name.getGivenName().setValue(firstName);
		    name.getNameTypeCode().setValue("L");
		}
	}
}
